<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="keywords" content="Vacinação, Vacina da Gripe, Vacivitta, Influenza">
    <meta name="description" content="Garanta a sua proteção e da sua família, agende sua vacina contra Influenza">
    <meta name="author" content="Igor Henrique Constant">

    <link rel="shortcut icon" href="assets/images/cropped-vacivitta-icones-192x192.png" type="image/x-icon">

    <title>Vacivitta - Vacina da Gripe</title>


    <!-- CSS -->
    <link rel="stylesheet" href="assets/css/main.css">

    <!-- FontAwesome -->
    <script src="https://kit.fontawesome.com/7bc0885a91.js"></script>


</head>

<body>

    <header>
        <?php include('pages/header.php') ?>
    </header>

    <main>
        <section id="intro">
            <?php include('pages/intro.php') ?>
        </section>
        <section id="about">
            <?php include('pages/about.php') ?>
        </section>
        <section id="ctaBlock">
            <?php include('pages/ctaBlock.php') ?>
        </section>
        <section id="contact">
            <?php include('pages/contact.php') ?>
        </section>
    </main>

    <footer>
        <?php include('pages/footer.php') ?>
    </footer>


    <section id="alert">
        <div class="container">
            <div class="cookie-popup cookie-popup--short cookie-popup--dark">
                <div>
                    Esse site utiliza Cookies, para lhe oferecer uma experiência personalizada, você pode saber mais em <a target="_blank" href="politica-de-privacidade">Politica de Privacidade</a>
                </div>
                <div class="cookie-popup-actions">
                    <button>Aceito</button>
                </div>
            </div>
        </div>
    </section>

    <!-- JS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.11/jquery.mask.min.js"></script>
    <script src="scripts/form-handler.js"></script>
    <script src="scripts/cookies.js"></script>

    <script>
        $("#inputCelular, #inputCelularFooter").mask("(00) 00000-0000");
    </script>

</body>

</html>